package doABC;

import java.nio.*;
import java.util.*;

import FlashReader.*;

public class MethodBodyInfo extends SwfTools{

		private String[] opNames = {
	     	    "OP_0x00       ",
	     	    "bkpt          ",
	     	    "nop           ",
	     	    "throw         ",
	     	    "getsuper      ",
	     	    "setsuper      ",
	     	    "dxns          ",
	     	    "dxnslate      ",
	     	    "kill          ",
	     	    "label         ",
	     	    "OP_0x0A       ",
	     	    "OP_0x0B       ",
	     	    "ifnlt         ",
	     	    "ifnle         ",
	     	    "ifngt         ",
	     	    "ifnge         ",
	     	    "jump          ",
	     	    "iftrue        ",
	     	    "iffalse       ",
	     	    "ifeq          ",
	     	    "ifne          ",
	     	    "iflt          ",
	     	    "ifle          ",
	     	    "ifgt          ",
	     	    "ifge          ",
	     	    "ifstricteq    ",
	     	    "ifstrictne    ",
	     	    "lookupswitch  ",
	     	    "pushwith      ",
	     	    "popscope      ",
	     	    "nextname      ",
	     	    "hasnext       ",
	     	    "pushnull      ",
	     	    "pushundefined ",
	     	    "pushconstant  ",
	     	    "nextvalue     ",
	     	    "pushbyte      ",
	     	    "pushshort     ",
	     	    "pushtrue      ",
	     	    "pushfalse     ",
	     	    "pushnan       ",
	     	    "pop           ",
	     	    "dup           ",
	     	    "swap          ",
	     	    "pushstring    ",
	     	    "pushint       ",
	     	    "pushuint      ",
	     	    "pushdouble    ",
	     	    "pushscope     ",
	     	    "pushnamespace ",
	     	    "hasnext2      ",
	     	    "OP_0x33       ",
	     	    "OP_0x34       ",
	     	    "OP_0x35       ",
	     	    "OP_0x36       ",
	     	    "OP_0x37       ",
	     	    "OP_0x38       ",
	     	    "OP_0x39       ",
	     	    "OP_0x3A       ",
	     	    "OP_0x3B       ",
	     	    "OP_0x3C       ",
	     	    "OP_0x3D       ",
	     	    "OP_0x3E       ",
	     	    "OP_0x3F       ",
	     	    "newfunction   ",
	     	    "call          ",
	     	    "construct     ",
	     	    "callmethod    ",
	     	    "callstatic    ",
	     	    "callsuper     ",
	     	    "callproperty  ",
	     	    "returnvoid    ",
	     	    "returnvalue   ",
	     	    "constructsuper",
	     	    "constructprop ",
	     	    "callsuperid   ",
	     	    "callproplex   ",
	     	    "callinterface ",
	     	    "callsupervoid ",
	     	    "callpropvoid  ",
	     	    "OP_0x50       ",
	     	    "OP_0x51       ",
	     	    "OP_0x52       ",
	     	    "OP_0x53       ",
	     	    "OP_0x54       ",
	     	    "newobject     ",
	     	    "newarray      ",
	     	    "newactivation ",
	     	    "newclass      ",
	     	    "getdescendants",
	     	    "newcatch      ",
	     	    "OP_0x5B       ",
	     	    "OP_0x5C       ",
	     	    "findpropstrict",
	     	    "findproperty  ",
	     	    "finddef       ",
	     	    "getlex        ",
	     	    "setproperty   ",
	     	    "getlocal      ",
	     	    "setlocal      ",
	     	    "getglobalscope",
	     	    "getscopeobject",
	     	    "getproperty   ",
	     	    "OP_0x67       ",
	     	    "initproperty  ",
	     	    "OP_0x69       ",
	     	    "deleteproperty",
	     	    "OP_0x6A       ",
	     	    "getslot       ",
	     	    "setslot       ",
	     	    "getglobalslot ",
	     	    "setglobalslot ",
	     	    "convert_s     ",
	     	    "esc_xelem     ",
	     	    "esc_xattr     ",
	     	    "convert_i     ",
	     	    "convert_u     ",
	     	    "convert_d     ",
	     	    "convert_b     ",
	     	    "convert_o     ",
	     	    "checkfilter   ",
	     	    "OP_0x79       ",
	     	    "OP_0x7A       ",
	     	    "OP_0x7B       ",
	     	    "OP_0x7C       ",
	     	    "OP_0x7D       ",
	     	    "OP_0x7E       ",
	     	    "OP_0x7F       ",
	     	    "coerce        ",
	     	    "coerce_b      ",
	     	    "coerce_a      ",
	     	    "coerce_i      ",
	     	    "coerce_d      ",
	     	    "coerce_s      ",
	     	    "astype        ",
	     	    "astypelate    ",
	     	    "coerce_u      ",
	     	    "coerce_o      ",
	     	    "OP_0x8A       ",
	     	    "OP_0x8B       ",
	     	    "OP_0x8C       ",
	     	    "OP_0x8D       ",
	     	    "OP_0x8E       ",
	     	    "OP_0x8F       ",
	     	    "negate        ",
	     	    "increment     ",
	     	    "inclocal      ",
	     	    "decrement     ",
	     	    "declocal      ",
	     	    "typeof        ",
	     	    "not           ",
	     	    "bitnot        ",
	     	    "OP_0x98       ",
	     	    "OP_0x99       ",
	     	    "concat        ",
	     	    "add_d         ",
	     	    "OP_0x9C       ",
	     	    "OP_0x9D       ",
	     	    "OP_0x9E       ",
	     	    "OP_0x9F       ",
	     	    "add           ",
	     	    "subtract      ",
	     	    "multiply      ",
	     	    "divide        ",
	     	    "modulo        ",
	     	    "lshift        ",
	     	    "rshift        ",
	     	    "urshift       ",
	     	    "bitand        ",
	     	    "bitor         ",
	     	    "bitxor        ",
	     	    "equals        ",
	     	    "strictequals  ",
	     	    "lessthan      ",
	     	    "lessequals    ",
	     	    "greaterthan   ",
	     	    "greaterequals ",
	     	    "instanceof    ",
	     	    "istype        ",
	     	    "istypelate    ",
	     	    "in            ",
	     	    "OP_0xB5       ",
	     	    "OP_0xB6       ",
	     	    "OP_0xB7       ",
	     	    "OP_0xB8       ",
	     	    "OP_0xB9       ",
	     	    "OP_0xBA       ",
	     	    "OP_0xBB       ",
	     	    "OP_0xBC       ",
	     	    "OP_0xBD       ",
	     	    "OP_0xBE       ",
	     	    "OP_0xBF       ",
	     	    "increment_i   ",
	     	    "decrement_i   ",
	     	    "inclocal_i    ",
	     	    "declocal_i    ",
	     	    "negate_i      ",
	     	    "add_i         ",
	     	    "subtract_i    ",
	     	    "multiply_i    ",
	     	    "OP_0xC8       ",
	     	    "OP_0xC9       ",
	     	    "OP_0xCA       ",
	     	    "OP_0xCB       ",
	     	    "OP_0xCC       ",
	     	    "OP_0xCD       ",
	     	    "OP_0xCE       ",
	     	    "OP_0xCF       ",
	     	    "getlocal0     ",
	     	    "getlocal1     ",
	     	    "getlocal2     ",
	     	    "getlocal3     ",
	     	    "setlocal0     ",
	     	    "setlocal1     ",
	     	    "setlocal2     ",
	     	    "setlocal3     ",
	     	    "OP_0xD8       ",
	     	    "OP_0xD9       ",
	     	    "OP_0xDA       ",
	     	    "OP_0xDB       ",
	     	    "OP_0xDC       ",
	     	    "OP_0xDD       ",
	     	    "OP_0xDE       ",
	     	    "OP_0xDF       ",
	     	    "OP_0xE0       ",
	     	    "OP_0xE1       ",
	     	    "OP_0xE2       ",
	     	    "OP_0xE3       ",
	     	    "OP_0xE4       ",
	     	    "OP_0xE5       ",
	     	    "OP_0xE6       ",
	     	    "OP_0xE7       ",
	     	    "OP_0xE8       ",
	     	    "OP_0xE9       ",
	     	    "OP_0xEA       ",
	     	    "OP_0xEB       ",
	     	    "OP_0xEC       ",
	     	    "OP_0xED       ",
	     	    "OP_0xEE       ",
	     	    "debug         ",
	     	    "debugline     ",
	     	    "debugfile     ",
	     	    "bkptline      ",
	     	    "timestamp     ",
	     	    "OP_0xF4       ",
	     	    "verifypass    ",
	     	    "alloc         ",
	     	    "mark          ",
	     	    "wb            ",
	     	    "prologue      ",
	     	    "sendenter     ",
	     	    "doubletoatom  ",
	     	    "sweep         ",
	     	    "codegenop     ",
	     	    "verifyop      ",
	     	    "decode        "
	};
	
	private final int OP_bkpt = 0x01;
	private final int OP_nop = 0x02;
	private final int OP_throw = 0x03;
	private final int OP_getsuper = 0x04;
	private final int OP_setsuper = 0x05;
	private final int OP_dxns = 0x06;
	private final int OP_dxnslate = 0x07;
	private final int OP_kill = 0x08;
	private final int OP_label = 0x09;
	private final int OP_ifnlt = 0x0C;
	private final int OP_ifnle = 0x0D;
	private final int OP_ifngt = 0x0E;
	private final int OP_ifnge = 0x0F;
	private final int OP_jump = 0x10;
	private final int OP_iftrue = 0x11;
	private final int OP_iffalse = 0x12;
	private final int OP_ifeq = 0x13;
	private final int OP_ifne = 0x14;
	private final int OP_iflt = 0x15;
	private final int OP_ifle = 0x16;
	private final int OP_ifgt = 0x17;
	private final int OP_ifge = 0x18;
	private final int OP_ifstricteq = 0x19;
	private final int OP_ifstrictne = 0x1A;
	private final int OP_lookupswitch = 0x1B;
	private final int OP_pushwith = 0x1C;
	private final int OP_popscope = 0x1D;
	private final int OP_nextname = 0x1E;
	private final int OP_hasnext = 0x1F;
	private final int OP_pushnull = 0x20;
	private final int OP_pushundefined = 0x21;
	private final int OP_pushconstant = 0x22;
	private final int OP_nextvalue = 0x23;
	private final int OP_pushbyte = 0x24;
	private final int OP_pushshort = 0x25;
	private final int OP_pushtrue = 0x26;
	private final int OP_pushfalse = 0x27;
	private final int OP_pushnan = 0x28;
	private final int OP_pop = 0x29;
	private final int OP_dup = 0x2A;
	private final int OP_swap = 0x2B;
	private final int OP_pushstring = 0x2C;
	private final int OP_pushint = 0x2D;
	private final int OP_pushuint = 0x2E;
	private final int OP_pushdouble = 0x2F;
	private final int OP_pushscope = 0x30;
	private final int OP_pushnamespace = 0x31;
	private final int OP_hasnext2 = 0x32;
	private final int OP_newfunction = 0x40;
	private final int OP_call = 0x41;
	private final int OP_construct = 0x42;
	private final int OP_callmethod = 0x43;
	private final int OP_callstatic = 0x44;
	private final int OP_callsuper = 0x45;
	private final int OP_callproperty = 0x46;
	private final int OP_returnvoid = 0x47;
	private final int OP_returnvalue = 0x48;
	private final int OP_constructsuper = 0x49;
	private final int OP_constructprop = 0x4A;
	private final int OP_callsuperid = 0x4B;
	private final int OP_callproplex = 0x4C;
	private final int OP_callinterface = 0x4D;
	private final int OP_callsupervoid = 0x4E;
	private final int OP_callpropvoid = 0x4F;
	private final int OP_newobject = 0x55;
	private final int OP_newarray = 0x56;
	private final int OP_newactivation = 0x57;
	private final int OP_newclass = 0x58;
	private final int OP_getdescendants = 0x59;
	private final int OP_newcatch = 0x5A;
	private final int OP_findpropstrict = 0x5D;
	private final int OP_findproperty = 0x5E;
	private final int OP_finddef = 0x5F;
	private final int OP_getlex = 0x60;
	private final int OP_setproperty = 0x61;
	private final int OP_getlocal = 0x62;
	private final int OP_setlocal = 0x63;
	private final int OP_getglobalscope = 0x64;
	private final int OP_getscopeobject = 0x65;
	private final int OP_getproperty = 0x66;
	private final int OP_getpropertylate = 0x67;
	private final int OP_initproperty = 0x68;
	private final int OP_setpropertylate = 0x69;
	private final int OP_deleteproperty = 0x6A;
	private final int OP_deletepropertylate = 0x6B;
	private final int OP_getslot = 0x6C;
	private final int OP_setslot = 0x6D;
	private final int OP_getglobalslot = 0x6E;
	private final int OP_setglobalslot = 0x6F;
	private final int OP_convert_s = 0x70;
	private final int OP_esc_xelem = 0x71;
	private final int OP_esc_xattr = 0x72;
	private final int OP_convert_i = 0x73;
	private final int OP_convert_u = 0x74;
	private final int OP_convert_d = 0x75;
	private final int OP_convert_b = 0x76;
	private final int OP_convert_o = 0x77;
	private final int OP_coerce = 0x80;
	private final int OP_coerce_b = 0x81;
	private final int OP_coerce_a = 0x82;
	private final int OP_coerce_i = 0x83;
	private final int OP_coerce_d = 0x84;
	private final int OP_coerce_s = 0x85;
	private final int OP_astype = 0x86;
	private final int OP_astypelate = 0x87;
	private final int OP_coerce_u = 0x88;
	private final int OP_coerce_o = 0x89;
	private final int OP_negate = 0x90;
	private final int OP_increment = 0x91;
	private final int OP_inclocal = 0x92;
	private final int OP_decrement = 0x93;
	private final int OP_declocal = 0x94;
	private final int OP_typeof = 0x95;
	private final int OP_not = 0x96;
	private final int OP_bitnot = 0x97;
	private final int OP_concat = 0x9A;
	private final int OP_add_d = 0x9B;
	private final int OP_add = 0xA0;
	private final int OP_subtract = 0xA1;
	private final int OP_multiply = 0xA2;
	private final int OP_divide = 0xA3;
	private final int OP_modulo = 0xA4;
	private final int OP_lshift = 0xA5;
	private final int OP_rshift = 0xA6;
	private final int OP_urshift = 0xA7;
	private final int OP_bitand = 0xA8;
	private final int OP_bitor = 0xA9;
	private final int OP_bitxor = 0xAA;
	private final int OP_equals = 0xAB;
	private final int OP_strictequals = 0xAC;
	private final int OP_lessthan = 0xAD;
	private final int OP_lessequals = 0xAE;
	private final int OP_greaterthan = 0xAF;
	private final int OP_greaterequals = 0xB0;
	private final int OP_instanceof = 0xB1;
	private final int OP_istype = 0xB2;
	private final int OP_istypelate = 0xB3;
	private final int OP_in = 0xB4;
	private final int OP_increment_i = 0xC0;
	private final int OP_decrement_i = 0xC1;
	private final int OP_inclocal_i = 0xC2;
	private final int OP_declocal_i = 0xC3;
	private final int OP_negate_i = 0xC4;
	private final int OP_add_i = 0xC5;
	private final int OP_subtract_i = 0xC6;
	private final int OP_multiply_i = 0xC7;
	private final int OP_getlocal0 = 0xD0;
	private final int OP_getlocal1 = 0xD1;
	private final int OP_getlocal2 = 0xD2;
	private final int OP_getlocal3 = 0xD3;
	private final int OP_setlocal0 = 0xD4;
	private final int OP_setlocal1 = 0xD5;
	private final int OP_setlocal2 = 0xD6;
	private final int OP_setlocal3 = 0xD7;
	private final int OP_debug = 0xEF;
	private final int OP_debugline = 0xF0;
	private final int OP_debugfile = 0xF1;
	private final int OP_bkptline = 0xF2;

	private int id;
	public static int method_body_count;

	private int codeBegin=0;
	private int codeEnd=0;
	private AbcFile abc;
	private SWF swf;
	
	private int start;
	private int end;
	
	//struktory
	private int method;
	private int max_stack;
	private int local_count;
	private int init_scope_depth;
	private int max_scope_depth;
	private int code_length;
	private byte code[]=null;//optional
	public  ArrayList<Instruction> EN_Instruction = new ArrayList<Instruction>();
	public  HashMap<Integer,Integer> EN_InstructionMapowanie = new HashMap<Integer,Integer>();

	
	private int exception_count;
	private ArrayList<ExceptionInfo> exception_info = new ArrayList<ExceptionInfo>();//optional
	private int trait_count;
	private ArrayList<TraitInfo> tinfo = new ArrayList<TraitInfo>();//optional

	
	public MethodBodyInfo(SWF swf,AbcFile abc,int method,int max_stack,int local_count,int init_scope_depth,
			int max_scope_depth,int code_length, byte code[], int exception_count,
			ArrayList<ExceptionInfo> exception_info, int trait_count,ArrayList<TraitInfo> tinfo){
		super();
		this.abc = abc;
		this.swf= swf;
		abc.ENmethod_body_info.add(this);
		id =abc.ENmethod_body_info.size()-1;
		
		this.method= method;
		this.max_stack= max_stack;
		this.local_count= local_count;
		this.init_scope_depth= init_scope_depth;
		this.max_scope_depth= max_scope_depth;
		this.code_length= code_length;
		this.code=code;//optional
		this.exception_count= exception_count;
		if ( exception_info!= null)
		this.exception_info = exception_info;//optional
		this.trait_count= trait_count;
		if(tinfo!=null)
		this.tinfo = tinfo;//optional
		method_body_count++;
	}
	

	private MethodBodyInfo(SWF swf,AbcFile abc){
		super();
		this.abc = abc;
		this.swf = swf;
		abc.ENmethod_body_info.add(this);
		id =abc.ENmethod_body_info.size()-1;
	}
	
	
	public static void method_body_info(ByteBuffer bbuf, int position, CpoolInfo cpool,AbcFile abc,SWF swf){
		try{
		
		bbuf.position(position);
				
		method_body_count = unsigned30int(bbuf);
		
		for (int i=0; i< method_body_count; i++){
			
			MethodBodyInfo method_body_info = new MethodBodyInfo(swf,abc);
			
			method_body_info.start = bbuf.position();
			
			method_body_info.method = unsigned30int(bbuf);
			
			method_body_info.max_stack = unsigned30int(bbuf);
			
			method_body_info.local_count = unsigned30int(bbuf);
			//method_body_info.local_count--;
			
			method_body_info.init_scope_depth = unsigned30int(bbuf);
			
			method_body_info.max_scope_depth = unsigned30int(bbuf);

			method_body_info.code_length = unsigned30int(bbuf);
			
			method_body_info.code = Arrays.copyOfRange(bbuf.array(), bbuf.position(), bbuf.position()+method_body_info.code_length);
			
			method_body_info.codeBegin = bbuf.position();
			
			method_body_info.codeEnd = bbuf.position()+method_body_info.code_length;
			
			//method_body_info.czytajKod2(method_body_info.codeBegin,method_body_info.codeEnd);
			
			bbuf.position(method_body_info.codeEnd);
			
			method_body_info.exception_count = unsigned30int(bbuf);
				
			for (int i3 =0; i3< method_body_info.exception_count; i3++)
					method_body_info.exception_info.add(new ExceptionInfo(bbuf,abc));
				
			method_body_info.trait_count = unsigned30int(bbuf);
				
			for (int i4 =0;i4 < method_body_info.trait_count; i4++)
				method_body_info.tinfo.add(new TraitInfo(abc,bbuf));
			
			method_body_info.end= bbuf.position()-1;
		}
		} catch (Exception e) {e.printStackTrace();}
	}

	public void czytajKod2(int pocz, int kon){

		swf.bbuf.position(pocz);
	
		ByteBuffer bbuf = swf.bbuf;
	
		System.out.println("pocz " + pocz);
		while (swf.bbuf.position()<kon){
			
			int opcode = unsignedByte(bbuf.get());
			int startDate = bbuf.position();
						switch(opcode)
						{
							case OP_debugfile:
							case OP_pushstring:
								unsigned32int(bbuf);
								break;
							case OP_pushnamespace:
								unsigned32int(bbuf);
								break;
							case OP_pushint:
								unsigned32int(bbuf);
								break;
							case OP_pushuint:
								unsigned32int(bbuf);
								break;
							case OP_pushdouble:
								unsigned32int(bbuf);                                
								break;
							case OP_getsuper: ;
							case OP_setsuper: ;
							case OP_getproperty: ;
							case OP_initproperty: ;
							case OP_setproperty: ;
							case OP_getlex: ;
							case OP_findpropstrict: ;
							case OP_findproperty:;
							case OP_finddef:;
							case OP_deleteproperty: ;
							case OP_istype: ;
							case OP_coerce: ;
							case OP_astype: ;
							case OP_getdescendants:
								unsigned32int(bbuf);				
								break;
							case OP_constructprop:
							case OP_callproperty:
							case OP_callproplex:
							case OP_callsuper:
							case OP_callsupervoid:
							case OP_callpropvoid:
								unsigned32int(bbuf); 
								unsigned32int(bbuf);
								break;
							case OP_newfunction: {
								unsigned32int(bbuf);
								break;
							}
							case OP_callstatic:
								unsigned32int(bbuf);
								unsigned32int(bbuf);
								break;
							case OP_newclass: 
								unsigned32int(bbuf);               
								break;
							case OP_lookupswitch:
								readS24(bbuf);
								int maxindex =unsigned32int(bbuf);
								for (int i1=0; i1 <= maxindex; i1++) {
									readS24(bbuf);
								}
								break;
							case OP_jump:
							case OP_iftrue:		case OP_iffalse:
							case OP_ifeq:		case OP_ifne:
							case OP_ifge:		case OP_ifnge:
							case OP_ifgt:		case OP_ifngt:
							case OP_ifle:		case OP_ifnle:
							case OP_iflt:		case OP_ifnlt:
							case OP_ifstricteq:	case OP_ifstrictne:
								readS24(bbuf);
								break;
							case OP_inclocal:
							case OP_declocal:
							case OP_inclocal_i:
							case OP_declocal_i:
							case OP_getlocal:
							case OP_kill:
							case OP_setlocal:
							case OP_debugline:
							case OP_getglobalslot:
							case OP_getslot:
							case OP_setglobalslot:
							case OP_setslot:
							case OP_pushshort:
							case OP_newcatch:
								unsigned32int(bbuf);
								break;
							case OP_debug:
								unsignedByte(bbuf.get());
								unsigned32int(bbuf);
								unsignedByte(bbuf.get());
								unsigned32int(bbuf);
								break;
							case OP_newobject:
								unsigned32int(bbuf);
								break;
							case OP_newarray:
								unsigned32int(bbuf);
								break;
							case OP_call:
							case OP_construct:
							case OP_constructsuper:
								unsigned32int(bbuf);
								break;
							case OP_pushbyte:
							case OP_getscopeobject:
								unsignedByte(bbuf.get());
								break;
							case OP_hasnext2:
								unsigned32int(bbuf);
								unsigned32int(bbuf);
							default:
								/*if (opNames[opcode] == ("0x"+opcode.toString(16).toUpperCase()))
									s += " UNKNOWN OPCODE"*/
								break;
						}
						
						byte [] b = new byte[bbuf.position()-startDate];
					
						bbuf.position(startDate);
						bbuf.get(b);

							EN_InstructionMapowanie.put(startDate-1, EN_Instruction.size());
						if (ifJump(opcode)){
							EN_Instruction.add(new InstructionJump(opcode,b,startDate-1));
						}else{
							EN_Instruction.add(new Instruction(opcode,b,startDate-1));
						}
						
					
		}
		initInsJump();//wypelniam pola InsJump, toIns

	}
	
	/**
	 * Sprawdza czy dana isntrukcja to skok
	 * @param opcode
	 * @return
	 */
	private boolean ifJump(int opcode){
		if(opcode == OP_ifnlt
			|| opcode == OP_ifnle 
			|| opcode == OP_ifngt
			|| opcode == OP_ifnge
			|| opcode == OP_jump
			|| opcode == OP_iftrue
			|| opcode == OP_iffalse
			|| opcode == OP_ifeq
			|| opcode == OP_ifne
			|| opcode == OP_iflt
			|| opcode == OP_ifle
			|| opcode == OP_ifgt
			|| opcode == OP_ifge
			|| opcode == OP_ifstricteq
			||opcode ==  OP_ifstrictne ){
			return true;
		}
		return false;
	}
	
	
	private void initInsJump(){
		for (Instruction ins : EN_Instruction){
			if (ifJump(ins.getOpcode())){
				byte[] jump = ins.getOperands();
				ByteBuffer bbuf = ByteBuffer.allocate(jump.length);
				bbuf.order(ByteOrder.LITTLE_ENDIAN);
				bbuf.put(jump);
				bbuf.position(0);
				int jumpOffset = readS24(bbuf);
				
				int insPos =0;
				
				if(jumpOffset<0) {
					insPos = ins.position+ins.getOperands().length+1;
				}
				else {
					insPos = ins.position +ins.getOperands().length+1;
				}
				
				
				
				int target = insPos+jumpOffset;
				
				//System.out.println(ins.position);
				//System.out.println("target "+target);

				if (EN_InstructionMapowanie.get(target) !=null){
				
					((InstructionJump)ins).toIns = EN_Instruction.get(EN_InstructionMapowanie.get(target));
				
				}
			}
		}
	}
	
	//przelicza skoki od nowa
	private void calculateJumps(){
		updateMapowanie();
		
		for (Instruction ins : EN_Instruction){
			if(ins.getClass() == InstructionJump.class){
				int offset;
				if(ins.position > ((InstructionJump)ins).toIns.position){
					offset = ins.position - ((InstructionJump)ins).toIns.position;
					offset*=-1;
				}else{
					//offset = ins.position + ((InstructionJump)ins).toIns.position + ins.;
				}
				
			}
		}
	}
	
	//przelicza od nowa pozycje w kodzie
	private void updateMapowanie(){
		EN_InstructionMapowanie = new HashMap<Integer,Integer>();
		int i=0;
		for (Instruction ins : EN_Instruction){
			ins.position = i;			
			i+=1+ins.getOperands().length;
		}
	}
	
	
	public String czytajKod(int pocz, int kon){
		
		swf.bbuf.position(pocz);
		StringBuffer  s= new StringBuffer();
		
		while (swf.bbuf.position()<kon){
			ByteBuffer bbuf = swf.bbuf;
			
			s.append(bbuf.position() +"\t");
			int opcode = unsignedByte(bbuf.get());
			
					
						s.append( opNames[opcode] );
						s.append( opNames[opcode].length() < 8 ? "\t\t" : "\t" );
							
						switch(opcode)
						{
								
							case OP_debugfile:
							case OP_pushstring:
								s.append( '"' + abc.getConstant_pool().getString(unsigned32int(bbuf)).replace("\n","\\n").replace("\t","\\t") + '"' );
								break;
							case OP_pushnamespace:
								s.append( " " +abc.getConstant_pool().getNamespace(unsigned32int(bbuf)) );
								break;
							case OP_pushint:
								int i = abc.getConstant_pool().getInts(unsigned32int(bbuf));
								s.append( i + "\t// 0x" + Integer.toHexString(i) );
								break;
							case OP_pushuint:
								int u = abc.getConstant_pool().uints.get(unsigned32int(bbuf));
								s.append( u + "\t// 0x" + Integer.toHexString(u) );
								break;
							case OP_pushdouble:
								s.append( " " +abc.getConstant_pool().doubles.get(unsigned32int(bbuf)) );                                
								break;
							case OP_getsuper: ;
							case OP_setsuper: ;
							case OP_getproperty: ;
							case OP_initproperty: ;
							case OP_setproperty: ;
							case OP_getlex: ;
							case OP_findpropstrict: ;
							case OP_findproperty:;
							case OP_finddef:;
							case OP_deleteproperty: ;
							case OP_istype: ;
							case OP_coerce: ;
							case OP_astype: ;
							case OP_getdescendants:
								s.append( " " +abc.getConstant_pool().getMultiname(unsigned32int(bbuf)) );
								
								break;
							case OP_constructprop:
							case OP_callproperty:
							case OP_callproplex:
							case OP_callsuper:
							case OP_callsupervoid:
							case OP_callpropvoid:
								s.append( " " +abc.getConstant_pool().getMultiname(unsigned32int(bbuf)) ); 
								               
								s.append( " (" + unsigned32int(bbuf) + ")" );
								break;
							case OP_newfunction: {
								int method_id = unsigned32int(bbuf);
								s.append( abc.methodsNames.get(method_id) );
								break;
							}
							case OP_callstatic:
								s.append( abc.methodsNames.get(unsigned32int(bbuf)) );
								s.append( " (" + unsigned32int(bbuf) + ")" );
								break;
							case OP_newclass: 
								s.append( " " +abc.ClassNames.get(unsigned32int(bbuf)) );               
								break;
							case OP_lookupswitch:
								int pos = bbuf.position()-1;
								int target = pos + readS24(bbuf);
								int maxindex =unsigned32int(bbuf);
								//s += "default:" + labels.labelFor(target) // target + "("+(target-pos)+")"
								s.append( "default:" + target );
								s.append( " maxcase:" + maxindex );
								for (int i1=0; i1 <= maxindex; i1++) {
									target = pos + readS24(bbuf);
									//s += " " + labels.labelFor(target) // target + "("+(target-pos)+")"
									s.append( " " + target );
								}
								break;
							case OP_jump:
							case OP_iftrue:		case OP_iffalse:
							case OP_ifeq:		case OP_ifne:
							case OP_ifge:		case OP_ifnge:
							case OP_ifgt:		case OP_ifngt:
							case OP_ifle:		case OP_ifnle:
							case OP_iflt:		case OP_ifnlt:
							case OP_ifstricteq:	case OP_ifstrictne:
								int offset = readS24(bbuf);
								int target1 = bbuf.position()+offset;
								//s += target + " ("+offset+")"
								s.append( target1 );
								//if (!((bbuf.position()) in labels))
								//	s += "\n"
								break;
							case OP_inclocal:
							case OP_declocal:
							case OP_inclocal_i:
							case OP_declocal_i:
							case OP_getlocal:
							case OP_kill:
							case OP_setlocal:
							case OP_debugline:
							case OP_getglobalslot:
							case OP_getslot:
							case OP_setglobalslot:
							case OP_setslot:
							case OP_pushshort:
							case OP_newcatch:
								s.append( unsigned32int(bbuf) );
								break;
							case OP_debug:
								s.append( unsignedByte(bbuf.get()) );
								s.append( " " + unsigned32int(bbuf) );
								s.append( " " +unsignedByte(bbuf.get()) );
								s.append( " " + unsigned32int(bbuf) );
								break;
							case OP_newobject:
								s.append( "{" + unsigned32int(bbuf) + "}" );
								break;
							case OP_newarray:
								s.append( "[" + unsigned32int(bbuf) + "]" );
								break;
							case OP_call:
							case OP_construct:
							case OP_constructsuper:
								s.append( "(" + unsigned32int(bbuf) + ")" );
								break;
							case OP_pushbyte:
							case OP_getscopeobject:
								s.append( unsignedByte(bbuf.get()) );
								break;
							case OP_hasnext2:
								s.append( unsigned32int(bbuf) + " " + unsigned32int(bbuf) );
							default:
								/*if (opNames[opcode] == ("0x"+opcode.toString(16).toUpperCase()))
									s += " UNKNOWN OPCODE"*/
								break;
						}
						s.append( "\n" );
						
		}
		return s.toString();
	}


	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			for(byte b:getUI32(method))
				result.add(b);
			
			for(byte b:getUI32(max_stack))
				result.add(b);
			
			for(byte b:getUI32(local_count))
				result.add(b);
			
			for(byte b:getUI32(init_scope_depth))
				result.add(b);
		
			for(byte b:getUI32(max_scope_depth))
				result.add(b);
			
			for(byte b:getUI32(code_length))
				result.add(b);
		
			//for (Instruction ins : EN_Instruction){
			//	result.addAll(ins.getBytes2());
			//}
			
			for (int i=0;i<code.length;i++)
				result.add(code[i]);
		
			for(byte b:getUI32(exception_count))
				result.add(b);

			for (int i=0;i<exception_info.size();i++){
				for(byte b:exception_info.get(i).toByteCode())
				result.add(b);
			}
			
			for(byte b:getUI32(trait_count))
				result.add(b);
		
			for (int i=0;i<tinfo.size();i++){
				for(byte b:tinfo.get(i).toByteCode())
				result.add(b);
			}
		
	return result;
	}
	
	
	//getters


	public int getId() {
		return id;
	}

	public String getCode_string() {
		if (codeBegin ==0 &&  codeEnd==0) return "KOD NIE WKOMPILOWANY W SWF";
		return 	czytajKod( codeBegin, codeEnd);			
	}

	public int getStart() {
		return start;
	}

	public int getEnd() {
		return end;
	}

	public int getMethod() {
		return method;
	}

	public int getMax_stack() {
		return max_stack;
	}

	public int getLocal_count() {
		return local_count;
	}

	public int getInit_scope_depth() {
		return init_scope_depth;
	}

	public int getMax_scope_depth() {
		return max_scope_depth;
	}

	public int getCode_length() {
		return code_length;
	}

	public byte[] getCode() {
		return code;
	}

	public int getException_count() {
		return exception_count;
	}

	public ArrayList<ExceptionInfo> getException_info() {
		return exception_info;
	}

	public int getTrait_count() {
		return trait_count;
	}

	public ArrayList<TraitInfo> getTinfo() {
		return tinfo;
	}
	
	
	//setters
	
	public void setEnd(int end) {
		this.end = end;
		out("ok");
	}

	public void setMethod(int method) {
		this.method = method;
		out("ok");
	}

	public void setMax_stack(int max_stack) {
		this.max_stack = max_stack;
		out("ok");
	}

	public void setLocal_count(int local_count) {
		this.local_count = local_count;
		out("ok");
	}

	public void setInit_scope_depth(int init_scope_depth) {
		this.init_scope_depth = init_scope_depth;
		out("ok");
	}

	public void setMax_scope_depth(int max_scope_depth) {
		this.max_scope_depth = max_scope_depth;
		out("ok");
	}

	public void setCode_length(int code_length) {
		this.code_length = code_length;
		out("ok");
	}

	public void setCode(byte[] code) {
		this.code = code;
		code_length = code.length;
	}

	public void setException_count(int exception_count) {
		this.exception_count = exception_count;
		out("ok");
	}

	public void setException_info(ArrayList<ExceptionInfo> exception_info) {
		this.exception_info = exception_info;
		out("ok");
	}

	public void setTrait_count(int trait_count) {
		this.trait_count = trait_count;
		out("ok");
	}

	public void setOpNames(String[] opNames) {
		this.opNames = opNames;
		out("ok");
	}
	
	public void addException(ExceptionInfo ex){
		exception_info.add(ex);
		exception_count++;
	}
	
	public void addTrait(TraitInfo tr){
		tinfo.add(tr);
		trait_count++;
	}
	
	public void removeException(int id){
		exception_info.remove(id);
		exception_count--;
	}
	
	public void removeTrait(int id){
		tinfo.remove(id);
		trait_count--;
	}
	
	public void changeException(int id, ExceptionInfo ex){
		exception_info.set(id, ex);
	}
	
	public void changeTrait(int id, TraitInfo tr){
		tinfo.set(id, tr);
	}
	
	//toStrings
	public  String String(){
		
		StringBuffer wynik = new StringBuffer();

			wynik.append(">" + getStart() +"\n" );
			
			wynik.append( "method: "+getMethod()+"\n" );
			
			wynik.append( "max_stack: "+ getMax_stack()+"\n" );
			
			wynik.append( "local_count: "+ getLocal_count()+"\n" );
			
			wynik.append( "init_scope_depth: "+ getInit_scope_depth()+"\n" );
			
			wynik.append( "max_scope_depth: "+ getMax_scope_depth()+"\n" );
			
			wynik.append( "code_length: "+ getCode_length()+"\n" );
			
			wynik.append( "exception_count: "+ getException_count()+"\n" );
			
			//wynik+= "exception_info:"  +  getException_info()+"\n";
			
			wynik.append( "trait_count: "+ getTrait_count()+"\n" );
			
			//wynik+= "traits_info: " +getTinfo()+"\n";
			
			wynik.append( "<" + getEnd() +"\n" );

		return wynik.toString();
	}
	
	
	public String toString(){
		String wynik ="";
		wynik+="method_body_info id "+id+ " " +start+ " - " + end;
		return wynik;
	}
	public String toString2(){
		String wynik ="";
		wynik+="method_body_info";
		return wynik;
	}


}
